// Form1.h
//
// This file declares a Form-derived class that is also
// a remote TPI.NET client.
/////////////////////////////////////////////////////////////

#pragma once

namespace CPPRemoteClientSample {

ref class Form1 : public System::Windows::Forms::Form
{
private:
	// Members supporting the UI controls.
	System::Windows::Forms::Label^ m_versionLabel;
	System::Windows::Forms::Button^ m_runButton;
	System::Windows::Forms::Label^ m_label1;
	System::Windows::Forms::Label^ m_eventLabel;
	System::ComponentModel::Container^ m_components;
	void InitializeComponent();

	// A reference to the top of the TPI.NET object hierarchy
	// in the remote TLA application
	Tektronix::LogicAnalyzer::TpiNet::ITlaSystem^ m_system;
	
	// Keep track of how many acquisitions we have run.
	int m_startCount;
	int m_endCount;

	// Event shims that are required to subscribe to
	// events raised by the remote TLA application.
	System::EventHandler^ m_runStartHandler;
	System::EventHandler^ m_runCompleteHandler;
	
	// Add/Remove TPI.NET event subscriptions.
	void SubscribeToTpiNetEvents();
	void UnsubscribeFromTpiNetEvents();

	// Event Handlers for events raised by the TLA application
	void OnRunStarted (System::Object^ sender, System::EventArgs^ args);
	void OnRunCompleted (System::Object^ sender, System::EventArgs^ args);
	
	// Event Handler for events raised by the Form object.
	void OnRunButton (System::Object^ sender, System::EventArgs^ args);

public:
	// Construction/destruction.
    Form1(void);
	virtual ~Form1(void);
    
};

} // End namespace